<?php
/*--------------------------------------------------------------
   SerialCategories.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Category;
use IteratorAggregate;

class SerialCategories implements IteratorAggregate
{
    /**
     * @var Category[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Category ...$categories): self
    {
        return new self($categories);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator()
    {
        return new ArrayIterator($this->values);
    }
}